let config = {}

config.addon = {
  "URLS": {"urls": ["http://*/*", "https://*/*"]},
};

config.onBeforeSendHeaders = function (info) {
  let ACRH = info.requestHeaders.find(e => e.name.toLowerCase() === "access-control-request-headers");
};

config.onHeadersReceived = function (info) {
  let ACAOM = info.responseHeaders.filter(e => e.name.toLowerCase() !== 'access-control-allow-origin' && e.name.toLowerCase() !== 'access-control-allow-methods');
  //ACAOM.push({'name': 'Access-Control-Allow-Origin','value': info.initiator});
  ACAOM.push({'name': 'Access-Control-Allow-Methods', 'value': 'GET, PUT, POST, DELETE, HEAD, OPTIONS'});
  /*  */
  return {"responseHeaders": ACAOM};
};

chrome.webRequest.onHeadersReceived.addListener(config.onHeadersReceived, config.addon.URLS, ["blocking", "responseHeaders"])
chrome.webRequest.onBeforeSendHeaders.addListener(config.onBeforeSendHeaders, config.addon.URLS, ["blocking", "requestHeaders"])

